<?php

////////////////////////////////////////
//          Load Styles
////////////////////////////////////////

function blank_scripts()
{
  wp_enqueue_style('css_styles', get_stylesheet_uri());
}
add_action('wp_enqueue_scripts', 'blank_scripts');

////////////////////////////////////////
//          Register Menus
////////////////////////////////////////

function blank_register_menus()
{
  register_nav_menu('top-menu', __('Top Menu'));
}

add_action('init', 'blank_register_menus');

////////////////////////////////////////
//        Add Post Thumbnails
////////////////////////////////////////

add_theme_support('post-thumbnails');

////////////////////////////////////////
//          Add Title Tag
////////////////////////////////////////

function blank_slug_setup()
{
  add_theme_support('title-tag');
}

add_action('after_setup_theme', 'blank_slug_setup');

////////////////////////////////////////
//        Add Slug to Body Class
////////////////////////////////////////

function add_slug_body_class($classes)
{

  global $post;
  if (isset($post)) {
    $classes[] = $post->post_type . '-' . $post->post_name;
  }
  return $classes;
}

add_filter('body_class', 'add_slug_body_class');

////////////////////////////////////////
//    Display Page Name as Menu ID
////////////////////////////////////////

function menu_id_page($item, $args)
{
  $page = get_post($args->object_id);
  $item = $page->post_name;
  return $item;
}
add_filter('nav_menu_item_id', 'menu_id_page', 10, 2);

////////////////////////////////////////
//     Remove NBSP from Content
////////////////////////////////////////

add_filter('content_save_pre', 'remove_nbsps');

function remove_nbsps($content)
{

  $content = str_replace('&nbsp;', ' ', $content);

  return $content;
}

////////////////////////////////////////
//     Remove Default Body Field
////////////////////////////////////////

add_action('init', 'init_remove_support', 100);
function init_remove_support()
{
  // remove_post_type_support('page', 'editor');
  // remove_post_type_support('post', 'editor');
}

////////////////////////////////////////
//         Theme Options Page
////////////////////////////////////////

if (function_exists('acf_add_options_page')) {

  acf_add_options_page(array(
    'page_title'   => 'Theme General Settings',
    'menu_title'  => 'Theme Settings',
    'menu_slug'   => 'theme-general-settings',
    'capability'  => 'edit_posts',
    'redirect'    => false
  ));
}

////////////////////////////////////////
//         Get Current Browser
////////////////////////////////////////

function getBrowser()
{

  $user_agent = $_SERVER['HTTP_USER_AGENT'];
  $browser = "N/A";

  $browsers = array(
    '/msie/i' => 'Internet Explorer',
    '/firefox/i' => 'Firefox',
    '/safari/i' => 'Safari',
    '/chrome/i' => 'Chrome',
    '/edge/i' => 'Edge',
    '/opera/i' => 'Opera',
    '/mobile/i' => 'Mobile browser'
  );

  foreach ($browsers as $regex => $value) {
    if (preg_match($regex, $user_agent)) {
      $browser = $value;
    }
  }

  return $browser;
}
